; robit.S
; 12/11/2013
; Charles O. Goddard


#include "m328Pdef-gcc.inc"

.section .text
.global main
.extern samples, sample_idx

#define NUM_SAMPLES 16

main:
    call pwm_init
    call adc_enable

    ; lds r26, ADCSRA
    ; ori r24, 0x05
    ; sts ADCSRA, r24
    ; ldi r24, 0x20
    ; sts ADMUX, r24
    ; lds e24, ADCSRA
    ; ori r24, 0x80
    ; sts ADCSRA, r24
    ; ldi r24, 0

    ldi R16, 0
    sts sample_idx, R16
    mov R1, R16

    .loop:
    ldi r24, 0
    call adc_read
    call add_sample
    call get_average

    ; Set steer angle PWM to 225+average (in R24)
    ldi R25, 0x00
    ori R25, 0x01
    sts OCR1AH, R25
    sts OCR1AL, R24

    rjmp .loop


    ; ; Set outputs to 1.3ms pulse -> OCR1X = 325 = 0x0145
    ; ; This should center the steering
    ; ldi R16, 0x01
    ; ldi R17, 0x45
    ; sts OCR1AH, R16
    ; sts OCR1AL, R17
    ; sts OCR1BH, R16
    ; sts OCR1BL, R17

; add_sample
; Parameters:
;   R24 - the value from the ADC
add_sample:
    mov R18, R24
    lds R25, sample_idx
    mov ZL, R25
    ldi ZH, 0


    subi ZL, lo8(-(samples))
    sbci ZH, hi8(-(samples))

    ld R24, Z
    cp R24, R18
    breq .return

    mov R24, R25
    subi R24, 0xFF
    sts sample_idx, R24
    cpi R24, 16
    brcs .ok
    sts sample_idx, R1
    .ok:
    lds ZL, sample_idx
    ldi ZH,  0
    subi ZL, lo8(-(samples))
    sbci ZH, hi8(-(samples))

    st Z, r18

    .return:
    ret

; get_average
; Returns:
;   R24 - average of last 16 samples
; Uses: 
;   Z
;   R1 must be 0
;   R18
;   R19
get_average:
    ldi ZL, lo8(samples)
    ldi ZH, hi8(samples)
    ldi R18, 0
    ldi R19, 0

    ; R19 = high byte of sum, R18 = low byte of sum
    .add_next:
    ld R24, Z+   ; Loads sample into R24, advances Z+
    add R18, R24 ; Adds R24 to total
    adc R19, R1  ; Any overflow/carry is added to R19

    ; Look at first value out of bounds
    ldi R24, hi8(samples+16)    ; Load into R24 because there's no cpci
    cpi ZL, lo8(samples+16)     ; is the current ZL = low of out of bound
    cpc ZH, R24                 ; if it is, is ZH?
    brne .add_next              ; if out of bounds, stop--you're done

    ; No divide instruction, shift right by 4 == divide by 16
    ldi R24, 4
    .divide:
    asr R19         ; arithmetic shift right the high (signed) byte
    ror R18         ; rotate the low byte right through carry bit (carry comes in at left)
    dec R24         ; divide complete, decrement R24 divide counter
    brne .divide    ; if R24 != 0, repeat

    mov R24, R18    ; avg should be four bits at most (otherwise black magic occurred)
    ret             ; Return to call with average in R24
    

pwm_init:
    ; Set PB1&PB2 as outputs
    in R16, DDRB
    ori R16, 0b00000110
    out DDRB, R16

    ; ICR1 = 4999 = 0x1387
    ldi R16, 0x13
    ldi R17, 0x87
    sts ICR1H, R16
    sts ICR1L, R17

    ; TCCR1A:
    ; COM1A1 | COM1B1 | WGM11
    ; 0b10100010 = 0xA2
    lds R16, TCCR1A
    ori R16, 0xA2
    sts TCCR1A, R16

    ; TCCR1B:
    ; WGM13 | WGM12 | CS11 | CS10
    ; 0b00011011 = 0x1B
    lds R16, TCCR1B
    ori R16, 0x1B
    sts TCCR1B, R16

    ret


adc_enable:
    ; Set ADMUX to  ADLAR
    ldi ZL, ADMUX
    ldi ZH, 0x00
    ldi R16, 0x20
    st Z, R16

    ; Read current value of ADCSRA
    ldi ZL, ADCSRA
    ld R16, Z

    ; OR with ADPS2, ADPS0, ADEN, ADFR, ADSC
    ; _BV(ADPS2) | _BV(ADPS0) | _BV(ADEN) = 
    ; 0b10000101 = 0xC5
    ori R16, 0xC5

    ; Write back to ADCSRA
    st Z, R16
    ret

; adc_read
; Parameters:
;   R24 = channel to read
; Returns:
;   R24 = 8 bits of data
adc_read:
    ; Set ADMUX to ADLAR | channel
    ; 0b00100000 = 0x20
    ori R24, 0x20
    sts ADMUX, R24

    ; Set ADSC in ADCSRA to start conversion
    lds R16, ADCSRA
    ori R16, (1 << ADSC)
    sts ADCSRA, R16

    ; Loop until ADCSRA has the ADIF bit set
    .retry:
    lds R16, ADCSRA
    sbrs R16, ADIF
    rjmp .retry

    ; Set ADIF to clear
    lds R16, ADCSRA
    ori R16, (1 << ADIF)
    sts ADCSRA, R16

    ; Read value from ADC port
    lds R24, ADCH
    ret

; pick_steer_angle
; Parameters:
;   R24 = sensor running average(voltage)
; Sets:
;   R25: 0x01
;   OCR1AH, OCR1AL: timer counter (steering PWM)
pick_steer_angle:
    ; Set steer angle PWM to 225+average (in R24)
    ldi R25, 0x01
    sts OCR1AH, R25
    sts OCR1AL, R24
    ret

; pick_steer_angle
; Parameters:
;   R24 = sensor running average(voltage)
; Sets:
;   OCR1BH, OCR1BL: timer counter (speed PWM)
pick_speed:
    ret